VERSION 5.00
Object = "{248DD890-BB45-11CF-9ABC-0080C7E7B78D}#1.0#0"; "MSWINSCK.OCX"
Begin VB.Form Form1 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "U3800 LAN CH1CH2 Power Ver. 1.0"
   ClientHeight    =   8415
   ClientLeft      =   810
   ClientTop       =   1095
   ClientWidth     =   12405
   Icon            =   "Form1.frx":0000
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   ScaleHeight     =   8415
   ScaleWidth      =   12405
   Begin VB.CommandButton Command4 
      Caption         =   "Clear"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   7440
      TabIndex        =   49
      Top             =   3240
      Width           =   975
   End
   Begin VB.CommandButton Command3 
      Caption         =   "Dual OFF"
      Height          =   375
      Index           =   8
      Left            =   10800
      TabIndex        =   48
      Top             =   7560
      Width           =   975
   End
   Begin VB.CommandButton Command3 
      Caption         =   "Dual ON"
      Height          =   375
      Index           =   7
      Left            =   10800
      TabIndex        =   47
      Top             =   7080
      Width           =   975
   End
   Begin VB.CommandButton Command3 
      Caption         =   "Overlay"
      Height          =   375
      Index           =   6
      Left            =   7680
      TabIndex        =   46
      Top             =   7560
      Width           =   975
   End
   Begin VB.Frame Frame1 
      Caption         =   "Select SPA"
      Height          =   975
      Left            =   8880
      TabIndex        =   43
      Top             =   5760
      Width           =   1455
      Begin VB.OptionButton Option2 
         Caption         =   "U3872"
         Height          =   255
         Left            =   240
         TabIndex        =   45
         Top             =   600
         Width           =   975
      End
      Begin VB.OptionButton Option1 
         Caption         =   "U3841/51"
         Height          =   255
         Left            =   240
         TabIndex        =   44
         Top             =   240
         Value           =   -1  'True
         Width           =   1095
      End
   End
   Begin MSWinsockLib.Winsock tcpClient 
      Left            =   8880
      Top             =   3360
      _ExtentX        =   741
      _ExtentY        =   741
      _Version        =   393216
   End
   Begin VB.TextBox Text13 
      Height          =   285
      Left            =   10080
      TabIndex        =   37
      Text            =   "192.168.0.1"
      Top             =   2280
      Width           =   1455
   End
   Begin VB.CommandButton Connect 
      BackColor       =   &H0080FF80&
      Caption         =   "Connect"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   495
      Left            =   10080
      Style           =   1  'Graphical
      TabIndex        =   0
      Top             =   2760
      Width           =   1455
   End
   Begin VB.TextBox Text11 
      Alignment       =   1  'Right Justify
      BackColor       =   &H0080FFFF&
      BeginProperty Font 
         Name            =   "Tahoma"
         Size            =   26.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H000000FF&
      Height          =   720
      Left            =   6960
      TabIndex        =   34
      Top             =   600
      Width           =   1935
   End
   Begin VB.TextBox Text10 
      Alignment       =   1  'Right Justify
      BackColor       =   &H00FFFFC0&
      BeginProperty Font 
         Name            =   "Tahoma"
         Size            =   26.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H000000FF&
      Height          =   675
      Left            =   6960
      TabIndex        =   33
      Top             =   2400
      Width           =   1935
   End
   Begin VB.TextBox Text9 
      Alignment       =   1  'Right Justify
      Height          =   285
      Left            =   5640
      TabIndex        =   32
      Text            =   "0"
      Top             =   2280
      Width           =   495
   End
   Begin VB.TextBox Text8 
      Alignment       =   1  'Right Justify
      Height          =   285
      Left            =   5640
      TabIndex        =   31
      Text            =   "0"
      Top             =   2760
      Width           =   495
   End
   Begin VB.TextBox Text7 
      Alignment       =   1  'Right Justify
      Height          =   285
      Left            =   2880
      TabIndex        =   30
      Text            =   "0"
      Top             =   2760
      Width           =   495
   End
   Begin VB.TextBox Text6 
      Alignment       =   1  'Right Justify
      Height          =   285
      Left            =   5640
      TabIndex        =   29
      Text            =   "0"
      Top             =   3240
      Width           =   495
   End
   Begin VB.TextBox Text5 
      Alignment       =   1  'Right Justify
      Height          =   285
      Left            =   2880
      TabIndex        =   28
      Text            =   "0"
      Top             =   2280
      Width           =   495
   End
   Begin VB.TextBox Text4 
      Alignment       =   1  'Right Justify
      Height          =   285
      Left            =   2880
      TabIndex        =   27
      Text            =   "0"
      Top             =   3240
      Width           =   495
   End
   Begin VB.CommandButton MeasStop 
      BackColor       =   &H00C0C0FF&
      Caption         =   "Meas Stop"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   495
      Left            =   10080
      Style           =   1  'Graphical
      TabIndex        =   8
      Top             =   720
      Width           =   1455
   End
   Begin VB.CommandButton Command1 
      BackColor       =   &H00FFFFC0&
      Caption         =   "Frequency"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Index           =   6
      Left            =   3600
      Style           =   1  'Graphical
      TabIndex        =   6
      Top             =   2760
      Width           =   1935
   End
   Begin VB.CommandButton Command3 
      Caption         =   "SCRF OFF"
      Height          =   375
      Index           =   5
      Left            =   10800
      TabIndex        =   15
      Top             =   6360
      Width           =   975
   End
   Begin VB.CommandButton Command3 
      Caption         =   "SCRF ON"
      Height          =   375
      Index           =   4
      Left            =   10800
      TabIndex        =   14
      Top             =   5880
      Width           =   975
   End
   Begin VB.CommandButton Command3 
      Caption         =   "Full CH2"
      Height          =   375
      Index           =   3
      Left            =   9000
      TabIndex        =   13
      Top             =   7560
      Width           =   975
   End
   Begin VB.CommandButton Command3 
      Caption         =   "Full CH1"
      Height          =   375
      Index           =   2
      Left            =   9000
      TabIndex        =   12
      Top             =   7080
      Width           =   975
   End
   Begin VB.CommandButton Command3 
      Caption         =   "SPLIT"
      Height          =   375
      Index           =   1
      Left            =   7680
      TabIndex        =   11
      Top             =   7080
      Width           =   975
   End
   Begin VB.CommandButton Command3 
      Caption         =   "Preset"
      Height          =   375
      Index           =   0
      Left            =   7680
      TabIndex        =   10
      Top             =   6000
      Width           =   975
   End
   Begin VB.CommandButton Command1 
      BackColor       =   &H00FFFFC0&
      Caption         =   "Spurious(2Bands)"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Index           =   1
      Left            =   840
      Style           =   1  'Graphical
      TabIndex        =   2
      Top             =   3240
      Width           =   1935
   End
   Begin VB.CheckBox ContMode 
      Caption         =   "Continuity"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   240
      Left            =   10080
      TabIndex        =   16
      Top             =   360
      Width           =   1335
   End
   Begin VB.CommandButton Command2 
      BackColor       =   &H00C0C0FF&
      Caption         =   "Local"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   495
      Left            =   10080
      Style           =   1  'Graphical
      TabIndex        =   9
      Top             =   3360
      Width           =   1455
   End
   Begin VB.TextBox Text3 
      Alignment       =   1  'Right Justify
      Height          =   285
      Left            =   10560
      TabIndex        =   19
      Text            =   "1000"
      Top             =   4920
      Width           =   735
   End
   Begin VB.TextBox Text2 
      Alignment       =   1  'Right Justify
      Height          =   285
      Left            =   9120
      TabIndex        =   18
      Text            =   "20"
      Top             =   4920
      Width           =   735
   End
   Begin VB.TextBox Text1 
      Alignment       =   1  'Right Justify
      Height          =   285
      Left            =   7560
      TabIndex        =   17
      Text            =   "2412"
      Top             =   4920
      Width           =   855
   End
   Begin VB.CommandButton Command1 
      BackColor       =   &H0000FFFF&
      Caption         =   "Meas All (Using CH1+CH2)"
      BeginProperty Font 
         Name            =   "Tahoma"
         Size            =   18
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   975
      Index           =   7
      Left            =   720
      Style           =   1  'Graphical
      TabIndex        =   1
      Top             =   480
      Width           =   5535
   End
   Begin VB.CommandButton Command1 
      BackColor       =   &H00FFFFC0&
      Caption         =   "SBW (>500k)"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Index           =   4
      Left            =   3600
      Style           =   1  'Graphical
      TabIndex        =   7
      Top             =   2280
      Width           =   1935
   End
   Begin VB.CommandButton Command1 
      BackColor       =   &H00FFFFC0&
      Caption         =   "OBW (<26M)"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Index           =   3
      Left            =   840
      Style           =   1  'Graphical
      TabIndex        =   5
      Top             =   2760
      Width           =   1935
   End
   Begin VB.CommandButton Command1 
      BackColor       =   &H00FFFFC0&
      Caption         =   "AVG Power (1M)"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Index           =   5
      Left            =   3600
      Style           =   1  'Graphical
      TabIndex        =   4
      Top             =   3240
      Width           =   1935
   End
   Begin VB.CommandButton Command1 
      BackColor       =   &H00FFFFC0&
      Caption         =   "Channel Power"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Index           =   2
      Left            =   840
      Style           =   1  'Graphical
      TabIndex        =   3
      Top             =   2280
      Width           =   1935
   End
   Begin VB.TextBox txtRslt 
      BeginProperty Font 
         Name            =   "lr SVbN"
         Size            =   9
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   3735
      Left            =   240
      MultiLine       =   -1  'True
      ScrollBars      =   2  'Vertical
      TabIndex        =   20
      Top             =   4320
      Width           =   6855
   End
   Begin VB.Line Line19 
      BorderColor     =   &H00C000C0&
      X1              =   12000
      X2              =   12000
      Y1              =   4440
      Y2              =   5520
   End
   Begin VB.Line Line9 
      BorderColor     =   &H00C000C0&
      X1              =   10440
      X2              =   12000
      Y1              =   4440
      Y2              =   4440
   End
   Begin VB.Line Line8 
      BorderColor     =   &H00C000C0&
      X1              =   7320
      X2              =   8640
      Y1              =   4440
      Y2              =   4440
   End
   Begin VB.Line Line1 
      BorderColor     =   &H00C000C0&
      X1              =   7320
      X2              =   7320
      Y1              =   4440
      Y2              =   5520
   End
   Begin VB.Line Line18 
      BorderColor     =   &H80000011&
      X1              =   10560
      X2              =   10560
      Y1              =   6960
      Y2              =   8040
   End
   Begin VB.Line Line17 
      BorderColor     =   &H80000011&
      X1              =   12000
      X2              =   12000
      Y1              =   6960
      Y2              =   8040
   End
   Begin VB.Line Line16 
      BorderColor     =   &H80000011&
      X1              =   10560
      X2              =   12000
      Y1              =   8040
      Y2              =   8040
   End
   Begin VB.Line Line15 
      BorderColor     =   &H80000011&
      X1              =   10560
      X2              =   12000
      Y1              =   6960
      Y2              =   6960
   End
   Begin VB.Line Line14 
      BorderColor     =   &H80000011&
      X1              =   10320
      X2              =   10320
      Y1              =   6960
      Y2              =   8040
   End
   Begin VB.Line Line13 
      BorderColor     =   &H80000011&
      X1              =   7320
      X2              =   7320
      Y1              =   6960
      Y2              =   8040
   End
   Begin VB.Line Line12 
      BorderColor     =   &H80000011&
      X1              =   7320
      X2              =   10320
      Y1              =   8040
      Y2              =   8040
   End
   Begin VB.Line Line11 
      BorderColor     =   &H80000011&
      X1              =   7320
      X2              =   10320
      Y1              =   6960
      Y2              =   6960
   End
   Begin VB.Line Line10 
      BorderColor     =   &H00C000C0&
      X1              =   7320
      X2              =   12000
      Y1              =   5520
      Y2              =   5520
   End
   Begin VB.Label Label8 
      Caption         =   "Total Time  (sec)"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   6960
      TabIndex        =   42
      Top             =   2160
      Width           =   1935
   End
   Begin VB.Line Line7 
      BorderColor     =   &H00FF0000&
      X1              =   240
      X2              =   12120
      Y1              =   1800
      Y2              =   1800
   End
   Begin VB.Label Label11 
      Caption         =   "SPA Conditions"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00C000C0&
      Height          =   255
      Left            =   8880
      TabIndex        =   41
      Top             =   4320
      Width           =   1455
   End
   Begin VB.Label Label18 
      Caption         =   "Time"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   5640
      TabIndex        =   40
      Top             =   2040
      Width           =   495
   End
   Begin VB.Label Label17 
      Caption         =   "Time"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   2880
      TabIndex        =   39
      Top             =   2040
      Width           =   495
   End
   Begin VB.Label Label15 
      Caption         =   "(After All Items)"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   10080
      TabIndex        =   38
      Top             =   1320
      Width           =   1455
   End
   Begin VB.Line Line2 
      BorderColor     =   &H00FF0000&
      X1              =   9480
      X2              =   9480
      Y1              =   1800
      Y2              =   4080
   End
   Begin VB.Label Label10 
      Caption         =   "IP Address:"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   10200
      TabIndex        =   36
      Top             =   2040
      Width           =   1215
   End
   Begin VB.Label Label7 
      Caption         =   "Total Time  (sec)"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   6960
      TabIndex        =   35
      Top             =   360
      Width           =   1935
   End
   Begin VB.Line Line6 
      BorderColor     =   &H00FF0000&
      BorderWidth     =   2
      X1              =   12120
      X2              =   12120
      Y1              =   120
      Y2              =   4080
   End
   Begin VB.Line Line5 
      BorderColor     =   &H00FF0000&
      BorderWidth     =   2
      X1              =   240
      X2              =   240
      Y1              =   120
      Y2              =   4080
   End
   Begin VB.Line Line4 
      BorderColor     =   &H00FF0000&
      BorderWidth     =   2
      X1              =   240
      X2              =   12120
      Y1              =   4080
      Y2              =   4080
   End
   Begin VB.Line Line3 
      BorderColor     =   &H00FF0000&
      BorderWidth     =   2
      X1              =   240
      X2              =   12120
      Y1              =   120
      Y2              =   120
   End
   Begin VB.Label Label6 
      Caption         =   "m sec"
      Height          =   255
      Left            =   11400
      TabIndex        =   26
      Top             =   5040
      Width           =   495
   End
   Begin VB.Label Label5 
      Caption         =   "Sweep Time"
      Height          =   255
      Left            =   10560
      TabIndex        =   25
      Top             =   4680
      Width           =   975
   End
   Begin VB.Label Label4 
      Caption         =   "dBm"
      Height          =   255
      Left            =   9960
      TabIndex        =   24
      Top             =   5040
      Width           =   495
   End
   Begin VB.Label Label3 
      Caption         =   "Ref.Level"
      Height          =   255
      Left            =   9120
      TabIndex        =   23
      Top             =   4680
      Width           =   855
   End
   Begin VB.Label Label2 
      Caption         =   "MHz"
      Height          =   255
      Left            =   8520
      TabIndex        =   22
      Top             =   5040
      Width           =   495
   End
   Begin VB.Label Label1 
      Caption         =   "Frequency"
      Height          =   255
      Left            =   7560
      TabIndex        =   21
      Top             =   4680
      Width           =   975
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit
'*----------------------------------------------------------------------
'*.Program Name :        U3800 LAN_CH1CH2 V10
'*
'*      Sample software for Advantest Spectrum Analyzer U3800
'*       (2ch_Parallel_Meas_Sample (Spurious+other))
'*
'*.Description :
'*
'*.Revision History :
'*      Reference Program:              U3800 LAN_CH1CH2 by Hirakoso
'*      1.00:           11-Jan-2012     Release. by Hirakoso
'*
'*----------------------------------------------------------------------
'*.Copyright(c) 2012 ADVANTEST CORPORATION
'*.http://www.advantest.co.jp
'*----------------------------------------------------------------------

Dim MFREQ As Double                     'Center Frequency
Dim REFL As Double                      'Reference Level
Dim SWPT As Double                      'Sweep Time
Dim starttime As Double                 'Measurement Start Time
Dim AvgMode As Integer                  'Setup Flag (No key)
Dim MeasStopFlag As Integer             'Stop the Continuas Measurement
Dim MeasExeFlag As Integer              'Measuring Flag
Dim RemoteMode As Integer               'Remote Mode
Dim CHmode As String                    'Channel Select

Dim AllMeasTimeCH1 As Double            'CH1 All Meas Time
Dim AllMeasTimeCH2 As Double            'CH2 All Meas Time

Dim SpuriTime As Double
Dim CHPTime As Double
Dim AVGPTime As Double
Dim OBW99Time As Double
Dim FreqTime As Double
Dim OBW90Time As Double
'


'=======================================================================
'                ************* MAIN ROUTINE **************
'=======================================================================

Private Sub Command1_Click(index As Integer)

MFREQ = Val(Text1) * 1000000#
REFL = Val(Text2)
SWPT = Val(Text3)

AvgMode = 0                                     'AVG OFF (Fixed)
MeasStopFlag = ContMode.Value                   'Cont Sweep Flag
'---------------------------------------------------------------------------

If MeasExeFlag = 0 And RemoteMode = 1 Then      'During measurement? NO->DO
                                            
    MeasExeFlag = 1
    SendDtFunc ("REN")                          'Remote

    Select Case index
    
        Case 1
        
            MeasSpurious MFREQ, REFL            'Spurious Meas Mode
            Text10.Text = Format((SpuriTime + CHPTime + AVGPTime + OBW99Time + FreqTime + OBW90Time), "###0.00")
    
        Case 2
        
            MeasChPow MFREQ, REFL               'Channel Power Measurement
            Text10.Text = Format((SpuriTime + CHPTime + AVGPTime + OBW99Time + FreqTime + OBW90Time), "###0.00")
        
        Case 3
        
            MeasOBW MFREQ, REFL, 99             'OBW 99%, Span=52M
            Text10.Text = Format((SpuriTime + CHPTime + AVGPTime + OBW99Time + FreqTime + OBW90Time), "###0.00")
            
        Case 4
        
            MeasOBW MFREQ, REFL, 90             'OBW 90%, Span=1M
            Text10.Text = Format((SpuriTime + CHPTime + AVGPTime + OBW99Time + FreqTime + OBW90Time), "###0.00")
    
        Case 5
        
            MeasAvgPower MFREQ, REFL            'AVG Power (1MHz RBW Zero Span)
            Text10.Text = Format((SpuriTime + CHPTime + AVGPTime + OBW99Time + FreqTime + OBW90Time), "###0.00")
            
        Case 6
    
            'MeasFreq MFREQ, REFL               'Frequency Measurement (Marker Mode)
            MeasFreqByOBW MFREQ, REFL           ' (OBW Mode)
            Text10.Text = Format((SpuriTime + CHPTime + AVGPTime + OBW99Time + FreqTime + OBW90Time), "###0.00")
            
        Case 7
            
            Text11.Text = ""
            Command2.Enabled = False
 
            If ContMode.Value = 1 Then MeasStop.Enabled = True
            txtRslt.Text = ""                   'Message Box Clear
            MeasItemsAll MFREQ, REFL            'Spurious, TotPower, OBW99, OBW90
            
            Command2.Enabled = True
            MeasStop.Enabled = False
                
        Case Else
        
    End Select
    
    MeasExeFlag = 0
    
Else
    Beep                                        'Nothing
End If


End Sub


'===============================================================================
'                           Channel Power Measurement
'===============================================================================

Sub MeasChPow(measF As Double, measRef As Double)
Dim Power As Double

    txtRslt.SelText = vbCrLf & "==========CH Power Measurement....." & vbCrLf
    
    starttime = Timer '*******************************************************

    SendDtFunc ("ACTCH CH1")                     'Channel One
    CHmode = "X1; "                                   'Access Channel

    SendDtFunc (CHmode + "SI")                            'Sweep STOP
    SendDtFunc (CHmode + "PMEASAVG OFF")                  'AVG OFF
    SendDtFunc (CHmode + "SP 52 MZ")                      'Span 26*2 MHz
    SendDtFunc (CHmode + "CF " & Format(measF) & "HZ")    'Center frequency
    
    SendDtFunc (CHmode + "RB 1MZ; " + CHmode + "VB 1MZ")             'RBW 1MHz, VBW 1MHz
    ' SendDtFunc( CHmode + "AS")                          'SWEEP AUTO or setup
    SendDtFunc (CHmode + "SW" & Format(SWPT) & "MS")
    
    SendDtFunc (CHmode + "RO ON;" + CHmode + "RO 0DB")    'Level Offset
    SendDtFunc (CHmode + "RL " & Format(measRef) & "DB")  'Reference level
    
    SendDtFunc (CHmode + "WLX " & Format(measF) & "HZ")   'Ch Center
    SendDtFunc (CHmode + "WDX 22 MZ")                     'Ch Span
    
    SendDtFunc (CHmode + "PWCHON")                        'Ch Pow ON
    
    Call GetChPower(Power)                                   'Measurement
    
    'ʕ\
    txtRslt.SelText = "CH Power = " & Format(Power, "###0.00") & "dBm" & vbCrLf
    
   '--------------------OFF Routine ---------------------------
    SendDtFunc (CHmode + "PMEASOFF")                      'POW OFF
    SendDtFunc (CHmode + "RO OFF")                        'Level Offset Off
    SendDtFunc (CHmode + "CONTS")                         'Sweep continue
    
    DoEvents
    
'--------------------------------------------------------------------------------------------
    CHPTime = Timer - starttime
    Text5.Text = Format(CHPTime, "###0.00")
    
    SendDtFunc (CHmode + "AL ON")                  'Free Run

End Sub

'-------------------------------------------------------------------------------------------
Sub GetChPower(Power As Double)
Dim sBuff As String * 50

    If AvgMode = 0 Then                             'AverageȂꍇ
        SendDtFunc (CHmode + "SI")                            'Sweep once
        Call WaitSweepEnd
    Else                                            'Averageꍇ
        SendDtFunc (CHmode + "PMEASAVGONCE ONCE")             'AVG single
        SendDtFunc (CHmode + "PWCHTM 10")                     'CH Power AVG 10 times
        SendDtFunc (CHmode + "PMEASAVG ON")                   'AVG start
        SendDtFunc (CHmode + "CONTS")                         'Sweep continue
        WaitMeasEnd                                           'Wait MEAS end
    End If
    
    SendDtFunc (CHmode + "PWCH?")                    'GET POW data
    sBuff = ""
    sBuff = RcvDtFunc

    Power = sBuff


End Sub


'===============================================================================
'                           OBW n%, Measurement
'===============================================================================

Sub MeasOBW(measF As Double, measRef As Double, percent As Integer)
Dim sBuff As String * 50
Dim dRslt() As String
        
    If percent = 99 Then
        txtRslt.SelText = vbCrLf & "==========OBW 99% Measurement....." & vbCrLf
    Else
        txtRslt.SelText = vbCrLf & "==========SBW (OBW90%) Measurement....." & vbCrLf
    End If
        
    starttime = Timer '*********************************************************
    
    SendDtFunc ("ACTCH CH1")                     'Channel One
    CHmode = "X1; "                                   'Access Channel
    
    SendDtFunc (CHmode + "SI")                            'Sweep STOP
    SendDtFunc (CHmode + "PMEASAVG OFF")                  'AVG OFF
    If percent = 99 Then
        SendDtFunc (CHmode + "SP 52 MZ")                      'Span 26*2 MHz
        SendDtFunc (CHmode + "RB 1MZ; " + CHmode + "VB 1MZ")  'RBW 1MHz, VBW 1MHz
    Else
        SendDtFunc (CHmode + "SP 1 MZ")                        'Span 1 MHz
        SendDtFunc (CHmode + "RB 10KZ; " + CHmode + "VB 10KZ") 'RBW 10kHz, VBW 10kHz
    End If
    SendDtFunc (CHmode + "CF " & Format(measF) & "HZ")    'Center frequency
    
    SendDtFunc (CHmode + "RO ON;" + CHmode + "RO 0DB")    'Level Offset
    SendDtFunc (CHmode + "RL " & Format(measRef) & "DB")  'Reference level
  '  SendDtFunc( CHmode + "AS ON")                           'Sweep Time Auto
    SendDtFunc (CHmode + "SW" & Format(SWPT) & "MS")
    SendDtFunc (CHmode + "DET POS")                       'Detector mode (POSI)
                                                             'Auto --> Average DET
    SendDtFunc (CHmode + "OBWPER" & Format(percent))      'OBW percent setting

    SendDtFunc (CHmode + "OBWON")                         'Meas OBW
     
    If AvgMode = 0 Then                         'AverageȂꍇ
        SendDtFunc (CHmode + "SI")                            'Sweep once
        Call WaitSweepEnd
    Else                                        'Averageꍇ
        SendDtFunc (CHmode + "PMEASAVGONCE ONCE")             'AVG single
        SendDtFunc (CHmode + "OBWTM 10")                      'OBW AVG 10 times
        SendDtFunc (CHmode + "PMEASAVG ON")                   'AVG start
        SendDtFunc (CHmode + "CONTS")                         'Sweep continue
        WaitMeasEnd                                     'Wait MEAS end
'--------------------------------------------------------TRACE AVG----------
'        SendDtFunc( CHmode + "AGSGL")                         'AVG single
'        SendDtFunc( CHmode + "AG 10")                         'AVG 10 times
'        SendDtFunc( CHmode + "AGR")                           'AVG start
'        SendDtFunc( CHmode + "CONTS")                         'Sweep continue
'        WaitAvgEnd                                      'Wait AVG end
'---------------------------------------------------------------------------
    End If
    
    sBuff = ""
    SendDtFunc (CHmode + "OBW?")                          'GET OBW data
    sBuff = RcvDtFunc                                   'GET OBW data
        
    'ʕ\
    dRslt = Split(sBuff, ",")
    txtRslt.SelText = "OBW = " & Format(dRslt(1) / 1000000#, "###0.000") & "MHz" & vbCrLf
    
   ' txtRslt.SelText = " : OBW CF = " & Format(dRslt(0) / 1000000#, "###0.000") & "MHz" & vbCrLf
   
   
   '--------------------OFF Routine ---------------------------
    SendDtFunc (CHmode + "OBWON OFF")
    SendDtFunc (CHmode + "AGS")                           'AVG off
    SendDtFunc (CHmode + "DETAA ON")                      'Detector mode (Auto)
    SendDtFunc (CHmode + "RO OFF")                        'Level Offset Off
    SendDtFunc (CHmode + "CONTS")                         'Sweep continue
    
    DoEvents
   
'------------------------------------------------------------------------------
    If percent = 99 Then
        OBW99Time = Timer - starttime
        Text7.Text = Format(OBW99Time, "###0.00")
    Else
        OBW90Time = Timer - starttime
        Text9.Text = Format(OBW90Time, "###0.00")
    End If

    SendDtFunc (CHmode + "AL ON")                  'Free Run

End Sub

'===============================================================================
'                           Spurious Measurement
'===============================================================================

Sub MeasSpurious(measF As Double, measRef As Double)

Dim buf As String
Dim Mcount, Avgcount, i, j, m, n, band As Integer
Dim SWPdata1, SWPdata2, RELdata As String


    txtRslt.SelText = vbCrLf & "==========Spurious Measurement....." & vbCrLf & vbCrLf
    
    SendDtFunc ("ACTCH CH1")                     'Channel One
    CHmode = "X1; "                                   'Access Channel
    
    SendDtFunc (CHmode + "SI")                            'sweep single mode
    
    SWPdata1 = Format(SWPT) & "MS, "
    SWPdata2 = Format(SWPT + 300) & "MS, "
    RELdata = Format(measRef) & "DB, "
    
    SendDtFunc (CHmode + "SPRTBL 0")
    SendDtFunc (CHmode + "SPRFDEL")                'Table clear
    SendDtFunc (CHmode + "SPRFIN 10MZ, 2.35GZ, 1MZ, 10KZ," + SWPdata1 + RELdata + "AUTO, OFF, -26DB")
    SendDtFunc (CHmode + "SPRFIN 2.5GZ, 12.5GZ, 1MZ, 10KZ," + SWPdata2 + RELdata + "AUTO, OFF, -26DB")
    
    band = 2                            'Band Number *****
    
    
    starttime = Timer '***********************************************************
    
    '-------------------- Condition Setup (One Time) -------------------

    SendDtFunc (CHmode + "DY 0.1")                        'Peak search sensitivity
    SendDtFunc (CHmode + "DET POS")
'    SendDtFunc( CHmode + "RL " & Format(measRef) & "DB")  'Reference level
    SendDtFunc (CHmode + "RO ON; " + CHmode + "RO 0DB")   'Level Offset
    
    SendDtFunc (CHmode + "SPURI ON")                            'Measure Spurious
    
    
    '===================================================================
    
    '--------------------- AVG Condition ---------------------------------
    If AvgMode = 0 Then                   'AverageȂꍇ
        Avgcount = 1                            'Sweep once
    Else                                        'Averageꍇ
        Avgcount = 10                           '10 Sweep
    End If
    '--------------------- Measurement ---------------------------------
    
    For Mcount = 1 To Avgcount
    
        SendDtFunc (CHmode + "CONTS")             'continuous sweep
        
        For i = 1 To band
           WaitSweepEnd                              'Measurement
        Next i
        
        SendDtFunc (CHmode + "SI")                'sweep single mode
        
        SendDtFunc (CHmode + "SPURI?")
        
        buf = ""
        buf = RcvDtFunc                         ' Table
        txtRslt.SelText = "Spurious Table = " & buf & vbCrLf
        m = buf
            
        buf = RcvDtFunc
        txtRslt.SelText = buf                   ' Spurious Number & Data
        
        '------------------------- for GPIB ------------------------------
        '    For i = 1 To m                                              ' Table number
        '
        '       buf = ""
        '       buf = RcvDtFunc
        '       txtRslt.SelText = "Spurious Number = " & buf & vbCrLf    ' Spurious nember
        '       n = buf
        '
        '       For j = 1 To n                                  ' Spurious Data
        '           buf = ""
        '           buf = RcvDtFunc
        '           txtRslt.SelText = buf
        '       Next j
        '
        '    Next i

    Next Mcount
    
    
   '--------------------OFF Routine ---------------------------
    SendDtFunc (CHmode + "SPURI OFF")                ' End of Measure Spurious
    SendDtFunc (CHmode + "DETAA ON")
    SendDtFunc (CHmode + "RO OFF")            'Level Offset Off
    SendDtFunc (CHmode + "CONTS")                    ' continuous sweep
    
    DoEvents
   
    '------------------------------------------------------------------------------
    'txtRslt.SelText = "********** " & Format((Timer - starttime), "###0.00") & " sec" & vbCrLf
    SpuriTime = Timer - starttime
    Text4.Text = Format(SpuriTime, "###0.00")
    
    txtRslt.SelText = vbCrLf & "----- End of Spurious Measurement -----" & vbCrLf
    
    SendDtFunc (CHmode + "AL ON")                  'Free Run

End Sub


'***************************************************************************************
'                      1MHz BW AVG Power Measurement (ZERO SPAN BURST)
'***************************************************************************************

Sub MeasAvgPower(measF As Double, measRef As Double)
Dim Power As Double
Dim sBuff As String * 50
Dim i, Avgcount, TRmode As Integer

    
    txtRslt.SelText = vbCrLf & "==========1MHz BW Power Measurement....." & vbCrLf
    
    starttime = Timer '**********************************************************
    
    SendDtFunc ("ACTCH CH1")                     'Channel One
    CHmode = "X1; "                                   'Access Channel
    
    SendDtFunc (CHmode + "SI")                            'Sweep STOP
    
    SendDtFunc (CHmode + "DD 10")                         'dB/DIV=10
    
    SendDtFunc (CHmode + "SP 0HZ")                        'Span Zero
    SendDtFunc (CHmode + "CF " & Format(measF) & "HZ")    'Center frequency
        
    SendDtFunc (CHmode + "RB 1MZ; " + CHmode + "VB 3MZ")            'RBW 1MHz, VBW 3MHz
    SendDtFunc (CHmode + "SW 5MS")                        'SWEEP Time 5ms or ...
    SendDtFunc (CHmode + "DET AVG")                       'DET AVG
    
    SendDtFunc (CHmode + "RO ON; " + CHmode + "RO 0DB")   'Level Offset
    SendDtFunc (CHmode + "RL " & Format(measRef) & "DB")  'Reference level
    
    ' starttime = Timer  '***********************
    
    '--------------------- AVG Condition ---------------------------------
    If AvgMode = 0 Then                   'AverageȂꍇ
        Avgcount = 1                            'Sweep once
    Else                                        'Averageꍇ
        Avgcount = 10                           '10 Sweep
    End If
    '--------------------- Measurement ---------------------------------
    For i = 1 To Avgcount
        
        SendDtFunc (CHmode + "AW")                            'A Write
        SendDtFunc (CHmode + "SI")                            'Sweep once
        Call WaitSweepEnd
        SendDtFunc (CHmode + "AV")                            'VIEW
        
        TRmode = 0
        Call GetDataTrace(Power, TRmode)
     
    '-------------------------------------------------------------------------
    'ʕ\
    txtRslt.SelText = "AVG Power = " & Format(Power, "###0.00") & "dBm" & vbCrLf
 
    Next i
    
    '--------------------OFF Routine ---------------------------
    SendDtFunc (CHmode + "PMEASOFF")                      'POW OFF
    SendDtFunc (CHmode + "DETAA ON")                      'DET Auto
    SendDtFunc (CHmode + "AW")                            'A Write
    SendDtFunc (CHmode + "RO OFF")                        'Level Offset Off
    SendDtFunc (CHmode + "CONTS")                         'Sweep continue
    
    DoEvents
    
    '--------------------------------------------------------------------------
    AVGPTime = Timer - starttime
    Text6.Text = Format(AVGPTime, "###0.00")
    
    SendDtFunc (CHmode + "AL ON")                  'Free Run

End Sub

'===================================1000 Points Version====================================

Sub GetDataTrace(Power As Double, TRmode As Integer)

Dim Rslt As Integer, tmp As Integer, i As Integer
Dim CentLv As Integer, SerLv As Integer, Sp As Integer

Dim StartPt As Integer
Dim dbm(1000) As Double
Dim PowerWt As Double


    SendDtFunc ("DLIM2")               ' Set EOI @U3751
    
    If TRmode = 0 Then
        SendDtFunc (CHmode + "TBA?")                 ' A TRace & Set BIN mode
    Else
        SendDtFunc (CHmode + "TBB?")                 ' B Trace
    End If
    
    bGetWave                                         ' Get Trace Data
    
    
'    Call ibrdi(ud, TraceP(), 1001 * 2)                  ' Read BIN data 1000 points
'    For i = 0 To 1000 Step 1
'        tmp = TraceP(i)
'        Rslt = (tmp And &HFF&) * 256
'        TraceP(i) = Rslt + ((tmp And &HFF00&) / 256)
'    Next i
'
'    SendDtFunc ("DLIM0")                 'Reset EOI @U3751
   
'---------------------------------- Max Data
    tmp = 0
    For i = 0 To 1000
        If TraceP(i) > tmp Then
            tmp = TraceP(i)
        End If
    Next i
'---------------------------------- Center Limit Level
    CentLv = tmp - 2560                         ' Max Level - 2 div
'---------------------------------- Point 0 check & Serach Low Level
    Sp = 0
    If TraceP(Sp) > CentLv Then
        For Sp = 1 To 640 Step 20
            If TraceP(Sp) < CentLv Then Exit For
        Next Sp
    End If
'---------------------------------- Search High Level
    For i = Sp To 640 Step 10
        If TraceP(i) > CentLv Then Exit For
    Next i
'----------------------------------- Start point = i (point) + 50 (250 usec)

    StartPt = i + 50
    
'-----------------------------------
                                                        'Ref=REFL, dB/Div=10
    For i = StartPt To StartPt + 199                     '200 points = 1ms
        dbm(i) = REFL - (14592 - TraceP(i)) * 0.0078125
    Next i
        
    PowerWt = 0
    For i = StartPt To StartPt + 199
        dbm(i) = 10 ^ (dbm(i) / 10)
        PowerWt = PowerWt + dbm(i)
    Next i
    
    Power = 10 * ((Log(PowerWt / 200) / Log(10#)))
    
    
End Sub


'================================================================================
'                   Frequency Measurement by Marker Mode
'================================================================================

Sub MeasFreq(measF As Double, measRef As Double)

Dim MkrFreq As Double
Dim i, Avgcount As Integer
Dim sBuff As String * 50

    
    txtRslt.SelText = vbCrLf & "==========Frequency Measurement....." & vbCrLf
    
    starttime = Timer '********************************************************
    
    SendDtFunc ("ACTCH CH1")                     'Channel One
    CHmode = "X1; "                                   'Access Channel
    
    SendDtFunc (CHmode + "SI")                            'Sweep STOP
    SendDtFunc (CHmode + "SP 1 MZ")                       'Span 1 MHz (Check)
    SendDtFunc (CHmode + "CF " & Format(measF) & "HZ")    'Center frequency
    
    SendDtFunc (CHmode + "RB 10 KZ; " + CHmode + "VB 10 KZ")        'RBW 10kHz, VBW 10kHz
 '   SendDtFunc( CHmode + "AS")                            'SWEEP AUTO or setup
    SendDtFunc (CHmode + "SW" & Format(SWPT) & "MS")
    
    SendDtFunc (CHmode + "RO ON; " + CHmode + "RO 0DB")   'Level Offset
    SendDtFunc (CHmode + "RL " & Format(measRef) & "DB")  'Reference level
    
    SendDtFunc (CHmode + "DET POS")                       'Detector mode (POSI)

    '--------------------- AVG Condition ---------------------------------
    If AvgMode = 0 Then                   'AverageȂꍇ
        Avgcount = 1                            'Sweep once
    Else                                        'Averageꍇ
        Avgcount = 10                           '10 Sweep
    End If
    '--------------------- Measurement ---------------------------------
    For i = 1 To Avgcount
    
        SendDtFunc (CHmode + "SI")
        Call WaitSweepEnd
        SendDtFunc (CHmode + "PS")
        SendDtFunc (CHmode + "MF?")
        sBuff = ""
        sBuff = RcvDtFunc
        MkrFreq = sBuff
    'ʕ\
    txtRslt.SelText = "Frequency = " & Format(MkrFreq / 1000000, "###0.000") & "MHz" & vbCrLf
    
    Next i
    
    '--------------------OFF Routine ---------------------------
    SendDtFunc (CHmode + "MKOFF")                         'Marker OFF
    SendDtFunc (CHmode + "DETAA ON")                      'Detector mode (Auto)
    SendDtFunc (CHmode + "RO OFF")                        'Level Offset Off
    SendDtFunc (CHmode + "CONTS")                         'Sweep continue
    
    DoEvents
    
    '------------------------------------------------------------------------------
    FreqTime = Timer - starttime
    Text8.Text = Format(FreqTime, "###0.00")
    
    SendDtFunc (CHmode + "AL ON")                  'Free Run
    
End Sub


'===============================================================================
'                     Frequency Measurement by OBW Mode
'===============================================================================

Sub MeasFreqByOBW(measF As Double, measRef As Double)
Dim sBuff As String * 50
Dim dRslt() As String
        

    txtRslt.SelText = vbCrLf & "==========Frequency Measurement....." & vbCrLf
    
    starttime = Timer '*********************************************************
    
    SendDtFunc ("ACTCH CH1")                     'Channel One
    CHmode = "X1; "                                   'Access Channel
    
    SendDtFunc (CHmode + "SI")                            'Sweep STOP
    SendDtFunc (CHmode + "PMEASAVG OFF")                  'AVG OFF

    SendDtFunc (CHmode + "SP 1 MZ")                       'Span 1 MHz
    SendDtFunc (CHmode + "CF " & Format(measF) & "HZ")    'Center frequency
    
    SendDtFunc (CHmode + "RB 10KZ; " + CHmode + "VB 10KZ") 'RBW 10kHz, VBW 10kHz
    SendDtFunc (CHmode + "RO ON; " + CHmode + "RO 0DB")   'Level Offset
    SendDtFunc (CHmode + "RL " & Format(measRef) & "DB")  'Reference level
  '  SendDtFunc( CHmode + "AS ON")                           'Sweep Time Auto
    SendDtFunc (CHmode + "SW" & Format(SWPT) & "MS")
    SendDtFunc (CHmode + "DET POS")                       'Detector mode (POSI)
                                                             'Auto --> Average DET
    SendDtFunc (CHmode + "OBWPER" & "90 %")               'OBW percent setting

    SendDtFunc (CHmode + "OBWON")                         'Meas OBW
    
    If AvgMode = 0 Then                         'AverageȂꍇ
        SendDtFunc (CHmode + "SI")                            'Sweep once
        Call WaitSweepEnd
    Else                                        'Averageꍇ
        SendDtFunc (CHmode + "PMEASAVGONCE ONCE")             'AVG single
        SendDtFunc (CHmode + "OBWTM 10")                      'OBW AVG 10 times
        SendDtFunc (CHmode + "PMEASAVG ON")                   'AVG start
        SendDtFunc (CHmode + "CONTS")                         'Sweep continue
        WaitMeasEnd                                     'Wait MEAS end
'--------------------------------------------------------TRACE AVG----------
'        SendDtFunc( CHmode + "AGSGL")                         'AVG single
'        SendDtFunc( CHmode + "AG 10")                         'AVG 10 times
'        SendDtFunc( CHmode + "AGR")                           'AVG start
'        SendDtFunc( CHmode + "CONTS")                         'Sweep continue
'        WaitAvgEnd                                      'Wait AVG end
'---------------------------------------------------------------------------
    End If
    
    sBuff = ""
    SendDtFunc (CHmode + "OBW?")                          'GET OBW data
    sBuff = RcvDtFunc                                   'GET OBW data
        
    'ʕ\
    dRslt = Split(sBuff, ",")
'    txtRslt.SelText = "OBW = " & Format(dRslt(1) / 1000000#, "###0.000") & "MHz"

    txtRslt.SelText = "Frequency = " & Format(dRslt(0) / 1000000#, "###0.000") & "MHz" & vbCrLf
    
    
    '--------------------OFF Routine ---------------------------
    SendDtFunc (CHmode + "OBWON OFF")
    SendDtFunc (CHmode + "AGS")                           'AVG off
    SendDtFunc (CHmode + "DETAA ON")                      'Detector mode (Auto)
    SendDtFunc (CHmode + "RO OFF")                        'Level Offset Off
    SendDtFunc (CHmode + "CONTS")                         'Sweep continue
    
    DoEvents
    
'------------------------------------------------------------------------------
    FreqTime = Timer - starttime
    Text8.Text = Format(FreqTime, "###0.00")

    SendDtFunc (CHmode + "AL ON")                  'Free Run

End Sub


'================================================================================
'================================================================================
'       2ch SPA: Spurious + CH Power + OBW99 + OBW90 + Freq + AVG Power(1M)
'================================================================================
'================================================================================

Sub MeasItemsAll(measF As Double, measRef As Double)
Dim Power As Double
Dim sBuff As String * 50
Dim dRslt() As String
Dim buf As String
Dim Mcount, Avgcount, i, j, m, n, band As Integer
Dim SWPdata1, SWPdata2, RELdata As String
Dim TRmode As Integer

    '-------------------------------------------------
    
    SendDtFunc ("SYSMODE ASYNC")                    'SYNC Mode Off
    
    SendDtFunc ("ACTCH CH1")                        'Channel One
    CHmode = "X1; "                                 'Access Channel
    
    SWPdata1 = Format(SWPT) & "MS, "
    SWPdata2 = Format(SWPT + 300) & "MS, "
    RELdata = Format(measRef) & "DB, "
    
    SendDtFunc (CHmode + "SPRTBL 0")
    SendDtFunc (CHmode + "SPRFDEL")                'Table clear

    SendDtFunc (CHmode + "SPRFIN 10MZ, 2.35GZ, 1MZ, 10KZ," + SWPdata1 + RELdata + "AUTO, OFF, -26DB")
    SendDtFunc (CHmode + "SPRFIN 2.5GZ, 12.5GZ, 1MZ, 10KZ," + SWPdata2 + RELdata + "AUTO, OFF, -26DB")
    
'   SendDtFunc (CHmode + "SPRFIN 2.5GZ, 12.5GZ, 1MZ, 10KZ," + SWPdata2 + RELdata + "AUTO, OFF, -26DB")
    
    band = 2                                       'Band Number *****
    
    DoEvents
    
   '-------------------- Setup Table (One Time) -------------
   
Do                    'LOOP *****************************************************************

    txtRslt.Text = ""                               'Message Box Clear
    txtRslt.SelText = vbCrLf & "++++++++++ 2ch-SPA Mode All Items Measurement....." & vbCrLf

    starttime = Timer                               'Timer **********************************
    
    SendDtFunc ("ACTCH CH1")                        'SET Active CH1
    SendDtFunc ("SIALL")                            'Sweep STOP ALL CH
'    CHmode = "X1; "                                 'Access Channel
    CHmode = ""                                     'Now CH1 (=No data)
    '--------------------------------------------------------------------------

    SendDtFunc (CHmode + "DY 0.1")                        'Peak search sensitivity
    SendDtFunc (CHmode + "DET POS")
    SendDtFunc (CHmode + "RO ON;" + CHmode + "RO 0DB")    'Level Offset
    
    SendDtFunc (CHmode + "SPURI ON")                      'Measure Spurious
    
    '--------------------------------------------------------
    SendDtFunc ("ACTCH CH2")                        'SET Active CH2
    
    'CHmode = "X2; "                                'Access Channel
    CHmode = ""                                     'Now CH2 (= No data)
    
    SendDtFunc (CHmode + "SP 52 MZ")                      'Span 52MHz
    SendDtFunc (CHmode + "CF " & Format(measF) & "HZ")    'Center frequency
    SendDtFunc (CHmode + "RB 1MZ;" + CHmode + "VB 1MZ")   'RBW 1MHz, VBW 1MHz
    'SendDtFunc( CHmode + "AS")                           'SWEEP AUTO or setup
    SendDtFunc (CHmode + "SW" & Format(SWPT) & "MS")
    
    SendDtFunc (CHmode + "RO ON;" + CHmode + "RO 0DB")    'Level Offset
    SendDtFunc (CHmode + "RL " & Format(measRef) & "DB")  'Reference level

    SendDtFunc (CHmode + "AW; " + CHmode + "DETAA ON")              'A Write DET Auto
    SendDtFunc (CHmode + "BW; " + CHmode + "DETB POS")              'B Write DET Posi
    SendDtFunc (CHmode + "PMEASTRACE TRA")
    
    SendDtFunc (CHmode + "WLX " & Format(measF) & "HZ")             'Ch Center
    SendDtFunc (CHmode + "WDX 22 MZ")                               'Ch Span
    
    SendDtFunc (CHmode + "PWCHON")                        'CH Power ON
    
    DoEvents
    '--------------------------------------------------------------------------

    SendDtFunc ("SIALL")                            'CH1-SW1 & CH2-SW1 **************
                                                    'Measure Spurioua and Channel Power
    SendDtFunc ("*CLS")
    DoEvents
    
    '===========================
    SendDtFunc ("OPR 8")                            'CH1-Spurious: Sweep End ?
    CH1_SweepEnd                                    'And CH2 End (Same Sweep Time)
    '===========================                    'CH1-End1

    SendDtFunc ("SI1")                              'CH1-SW2 Next Spurous2 Sweep Start
    SendDtFunc ("*CLS")                             '*******
    '--------------------------------------------------------------------------
    
    '-----Get Data of Channel Power-----CH2 @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
    
    SendDtFunc (CHmode + "PWCH?")                   'GET POW data
    sBuff = ""
    sBuff = RcvDtFunc                               'GET POW data
    Power = sBuff

    'ʕ\
    txtRslt.SelText = vbCrLf & "Channel Power = " & Format(Power, "###0.00") & "dBm" & vbCrLf
    
 '   SendDtFunc( CHmode + "PMEASOFF")                     'POW OFF ;;; Auto change!!
 
    '-------Calculate OBW99 using Trace-B ------CH2 @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
    
    SendDtFunc (CHmode + "PMEASTRACE TRB")
    SendDtFunc (CHmode + "AV; " + CHmode + "BV")         'A View $ B View
    
    SendDtFunc (CHmode + "OBWON")
    SendDtFunc (CHmode + "OBWPER 99%")
    SendDtFunc (CHmode + "SW 20MS")                      'High Speed Set
        
    SendDtFunc (CHmode + "SI2")                          'CH2: 2nd Sweep *******
    
    DoEvents
    
    '===========================
    CH2_Direct_SWP_End                                   'OBW Sweep End? (Direct End Check)
    '===========================                         'CH2-End2

    SendDtFunc (CHmode + "OBW?")                         'GET OBW data
    sBuff = ""
    sBuff = RcvDtFunc                                    'GET OBW data
    
    'ʕ\
    dRslt = Split(sBuff, ",")
    txtRslt.SelText = vbCrLf & "OBW 99% = " & Format(dRslt(1) / 1000000#, "###0.000") & "MHz" & vbCrLf
'    txtRslt.SelText = " : Cent.F = " & Format(dRslt(0) / 1000000#, "###0.000") & "MHz" & vbCrLf
        
    '-----------------------------------------------------------------------------------------
    
    '---------SET SBW-------------------------------------
    
    SendDtFunc (CHmode + "AW; " + CHmode + "BW")          ' A Write B Write
    SendDtFunc (CHmode + "PMEASTRACE TRA")
    
    SendDtFunc (CHmode + "SP 1MZ")                        'Span 1MHz
    SendDtFunc (CHmode + "RB 10KZ;" + CHmode + "VB 10KZ") 'RBW 10kHz, VBW 10kHz
    'SendDtFunc( CHmode + "AS")                           'SWEEP AUTO or setup
    SendDtFunc (CHmode + "SW" & Format(SWPT) & "MS")
    SendDtFunc (CHmode + "OBWPER 90%")
    SendDtFunc (CHmode + "DET POS")                       'DET AVG
     
    '----------------------CH2: 3rd Sweep -----------------------------------------
    
    DoEvents
    
    SendDtFunc ("TS")                               'CH2 3rd Sweep for SBW(OBW99),Freq *********
                                                    'CH2-End3

    '--------Get Data of SBW and Frequency-----CH 2 @@@@@@@@@@@@@@@@@@@@@@@@@@@@
    
    'CHmode = "X2; "                                'Access Channel
    CHmode = ""                                     'Now CH2 (=No data)
    
    SendDtFunc (CHmode + "OBW?")                    'OBW ?
    sBuff = ""
    sBuff = RcvDtFunc                               'GET OBW & Frequnecy data
    
    'ʕ\
    dRslt = Split(sBuff, ",")
    txtRslt.SelText = vbCrLf & "SBW (OBW90%) = " & Format(dRslt(1) / 1000000#, "###0.000") & "MHz" & vbCrLf
    
    '------------------------------------------------Frequency Data-------------------
    
    txtRslt.SelText = vbCrLf & "Frequency = " & Format(dRslt(0) / 1000000#, "###0.000") & "MHz" & vbCrLf
    
    
    '==============================
    SendDtFunc ("OPR 8")
    CH1_SweepEnd                                          'Spurious2 CH1:2nd Sweep End ?
    '==============================                       'CH1-End2

    
    '-----Get Data of Spurious-----CH1 @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

    CHmode = "X1; "                                 'Access Channel

    SendDtFunc (CHmode + "SPURI?")

    buf = ""
    buf = RcvDtFunc                                ' Table
    txtRslt.SelText = vbCrLf & "Spurious Table = " & buf & vbCrLf
    m = buf

    buf = RcvDtFunc
    txtRslt.SelText = buf                          ' Number & data

    '---------------------------SET AVG Power condition-----------------------------
    
    SendDtFunc (CHmode + "SPURI OFF")                     'End of Measure Spurious
    
    'SendDtFunc( "RO ON; RO 0 DB")                        'Level Offset
    SendDtFunc (CHmode + "RL " & Format(measRef) & "DB")  'Reference level
    
    SendDtFunc (CHmode + "SP 0HZ")                        'Span Zero
    SendDtFunc (CHmode + "CF " & Format(measF) & "HZ")    'Center frequency
    
    SendDtFunc (CHmode + "RB 1MZ;" + CHmode + "VB 3MZ")             'RBW 1MHz, VBW 3MHz
    SendDtFunc (CHmode + "SW 5MS")                        'SWEEP Time 5ms or ...
    SendDtFunc (CHmode + "DET AVG")                       'DET AVG
       
    '----------------------CH1: 3rd Sweep ----------------------------------------
    SendDtFunc ("SI1")                                    'CH1 3rd Sweep for AVG Power *****
    SendDtFunc ("*CLS")                                   '*******
    DoEvents

    '==============================
    SendDtFunc ("OPR 8")
    CH1_SweepEnd                                          'AVG Power CH1:3rd Sweep End ?
    '==============================                       'CH1-End3
    
    
    '-----Get Data of AVG Power-----CH1 @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

    SendDtFunc (CHmode + "AV")                            'VIEW
    
    TRmode = 0
    Call GetDataTrace(Power, TRmode)
    
    '-----------------------------------------------------------------------------
    'ʕ\
    txtRslt.SelText = vbCrLf & "AVG Power (1MHz BW) = " & Format(Power, "###0.00") & "dBm" & vbCrLf
        
    
    '--------------------OFF Routine -------------------------------
    
    CHmode = ""                                  'Access Channel = CH2 Now
    
    SendDtFunc (CHmode + "DETAA ON")
    SendDtFunc (CHmode + "DETAB ON")
        
    CHmode = "X1; "                              'Access Channel
    
    SendDtFunc (CHmode + "DETAA ON")
    SendDtFunc (CHmode + "AW")                   'A Write
    
    SendDtFunc ("CONTSALL")                      'Continuous sweep
    
    DoEvents                                     'Exe Commands!

    '--------------------------------------------------------------------------------------------------
    AllMeasTimeCH2 = Timer - starttime
    Text11.Text = Format(AllMeasTimeCH2, "###0.00")
    'txtRslt.SelText = vbCrLf & "********** " & Format(AllMeasTimeCH2, "###0.00") & " sec" & vbCrLf
    '--------------------------------------------------------------------------------------------------
    
    txtRslt.SelText = vbCrLf & "-------- End of All Items Measurement---------" & vbCrLf

Loop While MeasStopFlag = 1

    '------------------------------------------------LOOP END

    CHmode = "X2; "                                 'Access Channel-2
    SendDtFunc (CHmode + "BB")
    SendDtFunc (CHmode + "OBWON OFF")
    SendDtFunc (CHmode + "AL ON")                   'All Auto CH2
    SendDtFunc (CHmode + "RO OFF")                  'Level Offset Off
    
    CHmode = "X1; "                                 'Access Channel-1
    SendDtFunc (CHmode + "AL ON")                   'All Auto CH1
    SendDtFunc (CHmode + "RO OFF")                  'Level Offset Off
    
    SendDtFunc ("ACTCH CH1")                        'SET Active CH1
    
        
End Sub





'===============================================================================
'                           Control Routin
'===============================================================================

' GOTO Local and LAN Disconnect
'---------------------------------------------------
Private Sub Command2_Click()

Dim ErrRet As Integer

If MeasExeFlag = 0 And RemoteMode = 1 Then

    txtRslt.SelText = vbCrLf & "GO TO LOCAL"
    
    SendDtFunc ("GTL")                           'GO TO Local
    
    LAN_Dicconnect (ErrRet)

    Sleep 100
    txtRslt.SelText = "  ------------->>> LOCAL: Ready..... " & vbCrLf
    
    RemoteMode = 0                                  'LOCAL
    
    Connect.Enabled = True
    Command2.Enabled = False
    Command1(7).Enabled = False
    MeasStop.Enabled = False
                                                
    'Only Go TO LOCAL
Else
    Beep
End If
    
End Sub

'Clear Measurement Time  (Each Measurement Items)
'--------------------------------------------------

Private Sub Command4_Click()

    SpuriTime = 0
    CHPTime = 0
    AVGPTime = 0
    OBW99Time = 0
    FreqTime = 0
    OBW90Time = 0
    
    Text4.Text = SpuriTime
    Text5.Text = CHPTime
    Text6.Text = AVGPTime
    Text7.Text = OBW99Time
    Text8.Text = FreqTime
    Text9.Text = OBW90Time
    
    Text10.Text = ""


End Sub

' LAN Connect
'---------------------------------------------------
Private Sub Connect_Click()

Dim ErrRet As Integer

    IP_ADRS = Text13.Text                              'IP Address Setting

    If RemoteMode = 0 Then
    
        LAN_Connect (ErrRet)
        
        If ErrRet = 0 Then
        
            txtRslt.SelText = vbCrLf & "Connect LAN Instrument" & vbCrLf

            SendDtFunc ("SYSMODE SYNC")                 'SYNC Mode On
            
            If Option2.Value = True Then
                SendDtFunc ("RFC RFC1")                 'U3872: Set low-input
                Sleep 100
            End If
            
            SendDtFunc ("SYSMODE ASYNC")                'SYNC Mode Off
            SendDtFunc ("ACTCH CH1")                    'Set CH1
            
            If Option1.Value = True Then
                txtRslt.SelText = " >>> Process mode is U3841/51: Set ASYNC Mode" & vbCrLf
            Else
                txtRslt.SelText = " >>> Process mode is U3872: Set Input-Low, ASYNC Mode" & vbCrLf
            End If

            
            RemoteMode = 1                      'Ready Remote
            
            Command2.Enabled = True
            Command1(7).Enabled = True
            Connect.Enabled = False
            
        Else
            Beep
            txtRslt.SelText = "  -----Error---->>> Please Check IP ADRS or etc..... " & vbCrLf
        End If
        
    Else
       Beep
       
    End If


End Sub

' Form Load
'----------------------------------------------------------
Private Sub Form_Load()

    MeasExeFlag = 0                     'Not ready measurement
    RemoteMode = 0
    
    txtRslt.Text = ""
    
    Command2.Enabled = False
    Command1(7).Enabled = False
    
    MeasStop.Enabled = False

End Sub

' SPA Contorl
'-----------------------------------------------------------
Private Sub Command3_Click(index As Integer)

If MeasExeFlag = 0 And RemoteMode = 1 Then        'During measurement?

    Select Case index
    
    Case 0
        
        txtRslt.SelText = vbCrLf & "Instrument Preset"
        
        SendDtFunc ("IP")                           'Instrument Preset
        DoEvents
        Sleep 3500                                  'Wait 3.5 sec
        
        If Option2.Value = True Then
            SendDtFunc ("RFC RFC1")                 'U3872: Set low-input
        End If
        
        SendDtFunc ("SYSMODE ASYNC")                'SYNC Mode Off
        SendDtFunc ("ACTCH CH1")                    'Set CH1
        
        If Option1.Value = True Then
            txtRslt.SelText = "  --->>> U3841/51 Preset Done & Set ASYNC Mode" & vbCrLf
        Else
            txtRslt.SelText = "  --->>> U3872 Preset Done & Set Input-Low, ASYNC Mode" & vbCrLf
        End If
        
        Command3(1).Enabled = True
        Command3(2).Enabled = True
        Command3(3).Enabled = True
        Command3(6).Enabled = True
        
    Case 1
    
        txtRslt.SelText = vbCrLf & "2 Screen Display Mode"
        SendDtFunc ("DISP SPLIT")
        Sleep 200
        txtRslt.SelText = "  ------------->>> Done" & vbCrLf
    
    Case 2
    
        txtRslt.SelText = vbCrLf & "CH1 Display Mode"
        SendDtFunc ("DISP FULL1")
        Sleep 200
        txtRslt.SelText = "  ------------->>> Done" & vbCrLf
    
    Case 3
    
        txtRslt.SelText = vbCrLf & "CH2 Display Mode"
        SendDtFunc ("DISP FULL2")
        Sleep 200
        txtRslt.SelText = "  ------------->>> Done" & vbCrLf
      
    Case 4
    
        txtRslt.SelText = vbCrLf & "SCRF ON"
        SendDtFunc ("SCRF ON")
        Sleep 200
        txtRslt.SelText = "  ------------->>> Done" & vbCrLf
        
    Case 5
    
        txtRslt.SelText = vbCrLf & "SCRF OFF"
        SendDtFunc ("SCRF OFF")
        Sleep 200
        txtRslt.SelText = "  ------------->>> Done" & vbCrLf
        
    Case 6                                                      'Overlay
    
        txtRslt.SelText = vbCrLf & "Overlay CH1 and CH2"
        SendDtFunc ("DISP OLAY")
        Sleep 200
        txtRslt.SelText = "  ------------->>> Done" & vbCrLf
    
    Case 7                                                      'Dual ON
    
        txtRslt.SelText = vbCrLf & "Dual Mode ON"
        SendDtFunc ("DUAL ON")
        Command3(1).Enabled = True
        Command3(2).Enabled = True
        Command3(3).Enabled = True
        Command3(6).Enabled = True
        Sleep 200
        txtRslt.SelText = "  ------------->>> Done" & vbCrLf
        
    Case 8                                                      'Dual OFF
    
        txtRslt.SelText = vbCrLf & "Dual Mode OFF"
        SendDtFunc ("DUAL OFF")
        Command3(1).Enabled = False
        Command3(2).Enabled = False
        Command3(3).Enabled = False
        Command3(6).Enabled = False
        Sleep 200
        txtRslt.SelText = "  ------------->>> Done" & vbCrLf

    Case Else
            
    End Select
    
    DoEvents                                                    'Wait Execution...

Else
    Beep                                                        'Nothing
End If

End Sub

' STOP Measurement
'---------------------------------------------------------------------
Private Sub MeasStop_Click()

    If MeasExeFlag = 1 Then                 'During measurement?
        Beep
        txtRslt.SelText = vbCrLf & "******* STOP after All Measurement *****"
        txtRslt.SelText = vbCrLf & "******* STOP after All Measurement *****"
        txtRslt.SelText = vbCrLf & "******* STOP after All Measurement *****" & vbCrLf
        MeasStopFlag = 0
        ContMode.Value = 0
    Else
        
    End If

End Sub


